# 機能設計書 53-ISAPI プロバイダー

## 概要

本ドキュメントは、Horse WebフレームワークにおけるISAPI（Internet Server Application Programming Interface）プロバイダー機能の設計を記述する。

### 本機能の処理概要

ISAPI プロバイダーは、Microsoft IIS（Internet Information Services）のISAPI拡張機能としてHorseアプリケーションを動作させるための機能を提供する。DLLとしてコンパイルされ、IISプロセス内でインプロセスで実行されるため、CGIよりも高いパフォーマンスを実現できる。

**業務上の目的・背景**：Windows ServerとIISを基盤とするエンタープライズ環境において、高性能なWebアプリケーションを運用する需要がある。ISAPI プロバイダーにより、IISの堅牢な機能（認証、SSL/TLS、ロードバランシング等）を活用しながら、Horseアプリケーションをネイティブに統合できる。プロセス起動オーバーヘッドがないため、高負荷環境に適している。

**機能の利用シーン**：
- IISを使用するWindows Server環境でのWebアプリケーション運用
- CGIのプロセス起動オーバーヘッドを回避したい場合
- IISの認証機能やSSL/TLS設定を活用したい場合
- エンタープライズ環境での高パフォーマンス要件がある場合

**主要な処理内容**：
1. ISAPI DLLとしてのエントリポイント関数のエクスポート
2. COM初期化フラグの設定（マルチスレッド対応）
3. ISAPIアプリケーションの初期化
4. WebModuleClass の設定による THorseWebModule の登録
5. 起動時コールバックの実行
6. Application.Run によるリクエスト処理

**関連システム・外部連携**：
- Microsoft IIS（Internet Information Services）
- Windows COM基盤（COINIT_MULTITHREADED）
- Delphi WebBroker フレームワーク（Web.Win.ISAPIApp）

**権限による制御**：ISAPI プロバイダー自体には権限制御機能はなく、IISの認証・認可設定に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Webモジュール | API連携 | ISAPIモジュールとしてHTTPリクエストを処理 |

## 機能種別

サーバー管理 / ISAPI実行基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Callback | TProc | No | 起動時コールバック | - |

### 入力データソース

- IISからのISAPIリクエスト
- IIS設定による環境パラメータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ISAPIレスポンス | - | IISを介したHTTPレスポンス |

### 出力先

- IISへのISAPIレスポンス送信

## 処理フロー

### 処理シーケンス

```
1. ISAPIエントリポイント関数呼び出し（IISによる）
   └─ GetExtensionVersion / HttpExtensionProc / TerminateExtension
2. Listen メソッド呼び出し
   └─ InternalListen を呼び出す
3. COM初期化フラグ設定
   └─ CoInitFlags := COINIT_MULTITHREADED
4. ISAPIアプリケーション初期化
   └─ Application.Initialize 呼び出し
5. WebModuleClass 設定
   └─ THorseWebModule を Application.WebModuleClass に設定
6. コールバック実行
   └─ DoOnListen で起動時コールバック実行
7. アプリケーション実行
   └─ Application.Run でリクエスト処理開始
```

### フローチャート

```mermaid
flowchart TD
    A[IIS ISAPI呼び出し] --> B[Listen 呼び出し]
    B --> C{コールバックあり?}
    C -->|Yes| D[SetOnListen 設定]
    C -->|No| E[InternalListen 呼び出し]
    D --> E
    E --> F[CoInitFlags = COINIT_MULTITHREADED]
    F --> G[Application.Initialize]
    G --> H[WebModuleClass = THorseWebModule]
    H --> I[DoOnListen]
    I --> J[Application.Run]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | DLLインプロセス実行 | IISプロセス内でDLLとして実行 | ISAPI モード動作時 |
| BR-53-02 | マルチスレッド初期化 | COINIT_MULTITHREADED でCOM初期化 | ISAPI モード動作時 |
| BR-53-03 | ISAPIエントリポイント | GetExtensionVersion, HttpExtensionProc, TerminateExtension をエクスポート | DLLビルド時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | EHorseCallbackInterrupted | コールバックチェーン中断時 | 例外を捕捉して正常終了として扱う |

### リトライ仕様

ISAPIモデルではリトライ機能は実装されていない。IISのリトライ設定に依存する。

## トランザクション仕様

ISAPIモジュールとして動作するため、データベーストランザクションは本機能では管理しない。

## パフォーマンス要件

- インプロセス実行によりプロセス起動オーバーヘッドなし
- IISのスレッドプールを活用した高効率な処理
- 高負荷環境に適する

## セキュリティ考慮事項

- IISの認証・認可設定に依存
- DLLとして実行されるため、適切なファイル権限設定が必要
- IISアプリケーションプールの分離設定を推奨

## 備考

- HORSE_ISAPI コンパイルディレクティブが定義されている必要がある
- DLLプロジェクトとしてコンパイルする必要がある
- FPC/Lazarusではサポートされていない（Delphi専用）
- StopListen機能は提供されない（ISAPIモデルの特性上、IISが制御）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ISAPI プロバイダーはシンプルな構造のため、主に抽象クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | THorseProviderAbstract クラスの定義 |

**読解のコツ**: ISAPI プロバイダーはDLLとしてコンパイルされ、IISプロセス内で動作する。exports節でISAPIエントリポイント関数をエクスポートすることが重要。

#### Step 2: ISAPI プロバイダー本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.ISAPI.pas | `src/Horse.Provider.ISAPI.pas` | THorseProvider クラスの実装 |

**主要処理フロー**:
- **5行目**: `{$IF DEFINED(HORSE_ISAPI) AND NOT DEFINED(FPC)}` - Delphi専用条件コンパイル
- **9行目**: Web.Win.ISAPIApp ユニットを使用
- **30-33行目**: exports節 - ISAPI DLLエントリポイント関数のエクスポート
  - GetExtensionVersion: ISAPI拡張のバージョン情報を返す
  - HttpExtensionProc: HTTPリクエストを処理するメイン関数
  - TerminateExtension: ISAPI拡張のアンロード時に呼ばれる
- **35-42行目**: InternalListen - ISAPI アプリケーション初期化
- **37行目**: CoInitFlags := COINIT_MULTITHREADED - マルチスレッドCOM初期化
- **38行目**: Application.Initialize - ISAPIアプリケーション初期化
- **39行目**: WebModuleClass設定
- **40行目**: DoOnListen - コールバック実行
- **41行目**: Application.Run - リクエスト処理開始

#### Step 3: WebModuleを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | THorseWebModule クラス、リクエスト処理 |

**主要処理フロー**:
- **87-110行目**: HandlerAction - リクエスト・レスポンス処理
- **98行目**: FHorse.Routes.Execute - ルーティング実行

### プログラム呼び出し階層図

```
IIS (Internet Information Services)
    │
    ├─ GetExtensionVersion() [DLLエクスポート]
    │
    ├─ HttpExtensionProc() [DLLエクスポート]
    │      │
    │      └─ THorse (Horse.pas)
    │             │
    │             └─ THorseProvider (Horse.Provider.ISAPI.pas)
    │                    │
    │                    └─ Listen()
    │                           └─ InternalListen()
    │                                  ├─ CoInitFlags := COINIT_MULTITHREADED
    │                                  ├─ Application.Initialize()
    │                                  ├─ WebModuleClass := THorseWebModule
    │                                  ├─ DoOnListen()
    │                                  └─ Application.Run()
    │                                         └─ THorseWebModule.HandlerAction()
    │
    └─ TerminateExtension() [DLLエクスポート]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

IIS                    ┌─────────────────────────┐
   │                   │   ISAPI プロバイダー    │
   │                   │   (DLLインプロセス)     │
   ├─ HttpExtensionProc└───────────┬─────────────┘
   │   (ISAPIリクエスト)           │
   │                               ▼
   │                   ┌─────────────────────────┐
   │                   │   THorseWebModule       │───────▶ IIS
   │                   │ (リクエスト処理委譲)   │         (ISAPIレスポンス)
   │                   └───────────┬─────────────┘
   │                               │
   │                               ▼
   │                   ┌─────────────────────────┐
   │                   │   THorseCore.Routes     │
   │                   │   (ルーティング実行)    │
   │                   └─────────────────────────┘
   │
   └─ IIS認証/SSL ─────────────────────────────────────▶ セキュリティ処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.pas | `src/Horse.pas` | ソース | メインユニット、コンパイルディレクティブによるプロバイダー選択 |
| Horse.Provider.ISAPI.pas | `src/Horse.Provider.ISAPI.pas` | ソース | ISAPI プロバイダー実装 |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー抽象基底クラス |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | WebModuleクラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | コア機能（ルーティング等） |
| ISAPI.dpr | `samples/delphi/isapi/ISAPI.dpr` | プロジェクト | ISAPIサンプルプロジェクト |
